/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :   Mar 5 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_SpecialData.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/

#include "SST_Ext_ATP_SpecialData.h"
#include "SST_Ext_ATP_SpecialDataTstVectors.h"
#include "MW_ATP_UTIL_funcs.h"
#include "ExtApp_HOST_TST_Message.h"


#if TST_USE_SPECIAL_DATA_MODULE
/************************ Global Data **************************/
extern DxError_t      EXT_TST_ATP_Error;
extern DxUint8_t      EXT_FailureFunctionNameOut[TST_FUNC_STRING_LEN];
extern DxError_t      EXT_TST_TestStatus;

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpAES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of an AES symmetric key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_SpecialDataOpAES(  )
 {
 	
 
    /********* TST Variables Definitions ************/
    int                         TST_index =0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_SpecialDataOpAES";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;
    
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,"\n"));
	
	EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataAES_OP_CODE , 
                                           sizeof(EXT_ATP_SpecialDataOpAESTestDataStruct),
                                           SEP_ATP_SpecialDataOpAESTestData);
   
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SpecialDataOpAES", 
		                                          "HOSTQA_ATP_Message",TST_MasterTestName);											
    
	return EXT_TST_TestStatus;												                        
 }
/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpDES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of a DES symmetric key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_SpecialDataOpDES()
 {
 	
    /********* TST Variables Definitions ************/
    int                         TST_index =0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_SpecialDataOpDES";
    /********* TST Variables initialization *********/
	EXT_TST_TestStatus = TESTPASS;
	
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,"\n"));

	EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataDES_OP_CODE,
                                           sizeof(EXT_ATP_SpecialDataOpDESTestDataStruct),
	                                       SEP_ATP_SpecialDataOpDESTestData);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SpecialDataOpDES", 
		                                           "HOSTQA_ATP_Message",TST_MasterTestName);											
    
	return EXT_TST_TestStatus;												                        
 }
 
 /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpHMAC        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *  Test the insertion, generation, reading, deletion, and usage of a HMAC key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_SpecialDataOpHMAC()
 {
 	
    /********* TST Variables Definitions ************/
    int                         TST_index =0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_SpecialDataOpHMAC";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,"\n"));
													 
	EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataHMAC_OP_CODE,
                                           sizeof (EXT_ATP_SpecialDataOpHMACTestDataStruct),
	                                       SEP_ATP_SpecialDataOpHMACTestData);


	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SpecialDataOpHMAC", 
		                                           "HOSTQA_ATP_Message",TST_MasterTestName);											
    
	return EXT_TST_TestStatus;												                        
 }
 
 /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_SpecialDataOpRSA        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *  Test the insertion, generation, reading, deletion, and usage of a RSA key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_SpecialDataOpRSA()
 {
 	
    /********* TST Variables Definitions ************/
    int                         TST_index =0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_SpecialDataOpRSA";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;
    
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,"\n"));

	EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataRSA_OP_CODE,
	         							   sizeof (EXT_ATP_SpecialDataOpRSATestDataStruct),
	                                       SEP_ATP_SpecialDataOpRSATestData);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SpecialDataOpRSA", 
		                                           "HOSTQA_ATP_Message",TST_MasterTestName);											
    
	return EXT_TST_TestStatus;												                        
 }
  
#endif


